# Building Simple and Efficient Chatbots Step-by-Step

## Description

In this code demonstration, we're leveraging the LangChain Framework to build a sophisticated chatbot. We'll start by setting up the necessary environment and dependencies. Then, we'll dive into implementing LLM and RAG techniques to enhance the chatbot's responses, ensuring accuracy and engagement. Throughout the code, we'll explore efficient prompts and strategies to streamline the conversation flow. By the end, you'll have a comprehensive understanding of how to leverage advanced techniques to develop a powerful and intelligent chatbot solution.

## Getting Started

### Dependencies
- Azure OpenAI Service
- Python 3.x

### Executing Program

1. Clone the git repository.
2. Create a `.env` file to store the following environment variables:
   - `OPENAI_API_KEY`
   - `BASE_URL`
   - Deployment names for the `EMBEDDING_MODEL` and `CHAT_MODEL`.
3. Ensure that all files are located in the same folder.

These steps should help users effectively set up and run the program.

